# --------------------------------------------------------
# $Id: featured_products_english.sql,v 1.3 2008/08/22 22:30:20 aa0001 Exp $

#
# Table structure for table `featured`
#
# Find and replace '18' to the next `configuration_group_id` available
# in table `configuration_group`

CREATE TABLE `featured` (
  `featured_id` int(11) NOT NULL auto_increment,
  `products_id` int(11) NOT NULL default '0',
  `featured_date_added` datetime default NULL,
  `featured_last_modified` datetime default NULL,
  `expires_date` datetime default NULL,
  `date_status_change` datetime default NULL,
  `status` int(1) default '1',
  PRIMARY KEY  (`featured_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM;

INSERT INTO configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) VALUES ('18','Featured', 'Featured Products Display', '18', '1'
);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added) VALUES ('Display Featured Products', 'FEATURED_PRODUCTS_DISPLAY', 'true', 'Set to true or false in order to display featured.', '18', '1', now(), now()
);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added) VALUES ('Maximum Display of Featured', 'MAX_DISPLAY_FEATURED_PRODUCTS', '6', 'This is the maximum amount of items to display on the front page.', '18', '2', now(), now()
);

UPDATE `configuration` SET `set_function`="tep_cfg_select_option(array('true', 'false')," WHERE `configuration_key`='FEATURED_PRODUCTS_DISPLAY';

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, set_function) VALUES ('Include Sub Categories When Displaying Featured Products', 'FEATURED_PRODUCTS_SUB_CATEGORIES', 'true', 'Set to true or false in order to display featured including sub categories.', '18', '3', now(), now(), "tep_cfg_select_option(array('true', 'false'),");

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, set_function) VALUES ('Specials Only When Displaying Featured Products', 'FEATURED_PRODUCTS_SPECIALS_ONLY', 'false', 'Set to true or false in order to display only on special featured products.', '18', '4', now(), now(), "tep_cfg_select_option(array('true', 'false'),");
